from sqlalchemy.ext.asyncio import AsyncSession

from be_kit.paginations import PaginationQuery
from be_uam.user.models import User
from . import enums, schemas, repositories


async def create_tag(
    db: AsyncSession,
    tag: schemas.TagCreate,
    request_user: User,
):
    group = await request_user.awaitable_attrs.group
    repo = repositories.TagRepository(db)
    obj = await repo.acreate(
        **tag.model_dump(),
        organization_id=group.organization_id,
        created_by_id=request_user.pk,
    )
    return obj


async def list_tags(
    db: AsyncSession,
    pagination: PaginationQuery,
    filters: schemas.TagFilter,
    ordering: list[enums.TagOrdering] | None,
    request_user: User,
):
    group = await request_user.awaitable_attrs.group
    repo = repositories.TagRepository(db, organization_id=group.organization_id)
    objs = await repo.arecords(filters, pagination, ordering)
    return objs


async def update_tag(
    db: AsyncSession,
    pk: int,
    tag: schemas.TagUpdate,
    request_user: User,
):
    group = await request_user.awaitable_attrs.group
    repo = repositories.TagRepository(db, organization_id=group.organization_id)
    obj = await repo.aupdate(
        pk, **tag.model_dump(), last_modified_by_id=request_user.pk
    )
    return obj


async def delete_tag(db: AsyncSession, pk: int, request_user: User):
    group = await request_user.awaitable_attrs.group
    repo = repositories.TagRepository(db, organization_id=group.organization_id)
    await repo.adelete(pk)
