from typing_extensions import Annotated

from pydantic import PositiveInt, StringConstraints

from be_kit.paginations import BasePaginatedResponse
from be_kit.schemas import BaseSchema, BaseORMSchema
from be_uam.kit.schemas import MetadataMixin
from be_uam.user.schemas import UserMin


class BaseTag:
    name: Annotated[str, StringConstraints(min_length=3, max_length=30)]


class TagCreate(BaseTag, BaseSchema):
    pass


class TagUpdate(BaseTag, BaseSchema):
    pass


class Tag(MetadataMixin, BaseTag, BaseORMSchema):
    pass


class PaginatedTag(BasePaginatedResponse):
    items: list[Tag]


class TagFilter(BaseSchema):
    name: str | None = None
    name__icontains: str | None = None


class TagMin(BaseTag, BaseORMSchema):
    pass


class TagOpt(TagMin):
    pass


class PaginatedTagOpt(BasePaginatedResponse):
    items: list[TagOpt]


class TagListMixin:
    tags: list[TagMin]


class TagListWriteMixin:
    tag_ids: list[PositiveInt]


UserMin.model_rebuild()
