from sqlalchemy import (
    BigInteger,
    Enum,
    ForeignKey,
    String,
    UniqueConstraint,
)
from sqlalchemy.orm import Mapped, declared_attr, mapped_column, relationship

from be_kit.databases import BaseModel, SoftDeleteMixin
from be_uam.kit.models import MetadataMixin, OrganizationMixin
from . import enums


class Tag(OrganizationMixin, MetadataMixin, BaseModel):
    __tablename__ = "core_services_tag"
    __table_args__ = (UniqueConstraint("organization_id", "name"),)

    name: Mapped[str] = mapped_column(String(150))
