"""core_services: populate contact permissions

Revision ID: 41bdff811965
Revises: efc684579246
Create Date: 2025-09-25 15:19:17.953632

"""

from typing import Sequence, Union

from alembic import op
from sqlalchemy.orm import Session
from be_uam.permission.utils import populate_permissions
from be_core_services.permissions import contact_permissions


# revision identifiers, used by Alembic.
revision: str = "41bdff811965"
down_revision: Union[str, None] = "efc684579246"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    db = Session(bind=op.get_bind())
    populate_permissions(db, contact_permissions)
    db.close()


def downgrade() -> None:
    pass
