"""core_services: add contact

Revision ID: efc684579246
Revises: b2ab22fc2155
Create Date: 2025-09-25 15:18:53.238866

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = 'efc684579246'
down_revision: Union[str, None] = 'b2ab22fc2155'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_services_contact',
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('legal_type', sa.Enum('INDIVIDUAL', 'PARTNERSHIP', 'LIMITED_PARTNERSHIP', 'LIMITED_LIABILITY_PARTNERSHIP', 'LIMITED_LIABILITY_COMPANY', 'PUBLIC_LIMITED_COMPANY', 'PRIVATE_LIMITED_COMPANY', 'CORPORATION', 'NONPROFIT_ORGANIZATION', 'COOPERATIVE', 'TRUST', 'GOVERNMENT_AGENCY', name='contactlegaltype'), nullable=False),
    sa.Column('tax_id', sa.String(length=50), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_core_services_contact_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_core_services_contact_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_core_services_contact_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_core_services_contact')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_core_services_contact_organization_id'))
    )
    op.create_index(op.f('ix_core_services_contact_legal_type'), 'core_services_contact', ['legal_type'], unique=False)
    op.create_table('core_services_contact_address',
    sa.Column('contact_id', sa.BigInteger(), nullable=False),
    sa.Column('address_type', sa.Enum('MAIN', 'BILLING', 'SHIPPING', 'OTHER', name='contactaddresstype'), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('email', sa.String(length=100), nullable=True),
    sa.Column('address', sa.String(length=255), nullable=False),
    sa.Column('phone', sa.String(length=50), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['contact_id'], ['core_services_contact.pk'], name=op.f('fk_core_services_contact_address_contact_id_core_services_contact'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_core_services_contact_address')),
    sa.UniqueConstraint('contact_id', 'name', name=op.f('uq_core_services_contact_address_contact_id'))
    )
    op.create_index(op.f('ix_core_services_contact_address_address_type'), 'core_services_contact_address', ['address_type'], unique=False)
    op.create_table('core_services_contact_industry',
    sa.Column('contact_id', sa.BigInteger(), nullable=False),
    sa.Column('industry_type', sa.Enum('AGRICULTURE_FORESTRY_FISHING', 'MINING_QUARRYING', 'MANUFACTURING', 'UTILITIES', 'WATER_SUPPLY_WASTE_MANAGEMENT', 'CONSTRUCTION', 'WHOLESALE_RETAIL_TRADE', 'TRANSPORTATION_STORAGE', 'ACCOMMODATION_FOOD_SERVICE', 'INFORMATION_COMMUNICATION', 'FINANCIAL_INSURANCE', 'REAL_ESTATE', 'PROFESSIONAL_SCIENTIFIC_TECHNICAL', 'ADMINISTRATIVE_SUPPORT', 'PUBLIC_ADMINISTRATION', 'EDUCATION', 'HEALTH_SOCIAL_WORK', 'ARTS_ENTERTAINMENT_RECREATION', 'OTHER_SERVICE_ACTIVITIES', 'HOUSEHOLD_ACTIVITIES', 'EXTRATERRITORIAL_ACTIVITIES', name='contactindustrytype'), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['contact_id'], ['core_services_contact.pk'], name=op.f('fk_core_services_contact_industry_contact_id_core_services_contact'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('contact_id', 'industry_type', 'pk', name=op.f('pk_core_services_contact_industry')),
    sa.UniqueConstraint('contact_id', 'industry_type', name=op.f('uq_core_services_contact_industry_contact_id'))
    )
    op.create_table('core_services_contact_tag',
    sa.Column('contact_id', sa.BigInteger(), nullable=False),
    sa.Column('tag_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['contact_id'], ['core_services_contact.pk'], name=op.f('fk_core_services_contact_tag_contact_id_core_services_contact'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['tag_id'], ['core_services_tag.pk'], name=op.f('fk_core_services_contact_tag_tag_id_core_services_tag'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_core_services_contact_tag')),
    sa.UniqueConstraint('contact_id', 'tag_id', name=op.f('uq_core_services_contact_tag_contact_id'))
    )
    op.create_index(op.f('ix_core_services_contact_tag_contact_id'), 'core_services_contact_tag', ['contact_id'], unique=False)
    op.create_index(op.f('ix_core_services_contact_tag_tag_id'), 'core_services_contact_tag', ['tag_id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_core_services_contact_tag_tag_id'), table_name='core_services_contact_tag')
    op.drop_index(op.f('ix_core_services_contact_tag_contact_id'), table_name='core_services_contact_tag')
    op.drop_table('core_services_contact_tag')
    op.drop_table('core_services_contact_industry')
    op.drop_index(op.f('ix_core_services_contact_address_address_type'), table_name='core_services_contact_address')
    op.drop_table('core_services_contact_address')
    op.drop_index(op.f('ix_core_services_contact_legal_type'), table_name='core_services_contact')
    op.drop_table('core_services_contact')
    # ### end Alembic commands ###
