"""core_services: populate default data

Revision ID: b2ab22fc2155
Revises: 99b2c9f54489
Create Date: 2025-09-23 01:17:43.378809

"""

from typing import Sequence, Union

from alembic import op
from sqlalchemy.orm import Session
from be_core_services.country.repositories import (
    CountryRepository,
    CurrencyRepository,
    PhoneCodeRepository,
    VATRepository,
    BankRepository,
)
from be_core_services.country.defaults import (
    COUNTRY_LIST,
    CURRENCY_LIST,
    PHONE_CODE_LIST,
    VAT_LIST,
    BANK_LIST,
)


# revision identifiers, used by Alembic.
revision: str = "b2ab22fc2155"
down_revision: Union[str, None] = "99b2c9f54489"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    db = Session(bind=op.get_bind())

    country_repo = CountryRepository(db)
    for country in COUNTRY_LIST:
        country_repo.create(**country)

    currency_repo = CurrencyRepository(db)
    for currency in CURRENCY_LIST:
        currency_repo.create(**currency)

    phone_code_repo = PhoneCodeRepository(db)
    for phone_code in PHONE_CODE_LIST:
        phone_code_repo.create(**phone_code)

    vat_repo = VATRepository(db)
    for vat in VAT_LIST:
        vat_repo.create(**vat)

    bank_repo = BankRepository(db)
    for bank in BANK_LIST:
        bank_repo.create(**bank)

    db.close()


def downgrade() -> None:
    pass
