"""core_services: populate initial permissions

Revision ID: 99b2c9f54489
Revises: bfc6d386fbec
Create Date: 2025-09-23 01:17:10.541140

"""

from typing import Sequence, Union

from alembic import op
from sqlalchemy.orm import Session
from be_uam.permission.utils import populate_permissions
from be_core_services.permissions import permissions


# revision identifiers, used by Alembic.
revision: str = "99b2c9f54489"
down_revision: Union[str, None] = "bfc6d386fbec"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    db = Session(bind=op.get_bind())
    populate_permissions(db, permissions)
    db.close()


def downgrade() -> None:
    pass
