"""core_services: initial migrations

Revision ID: bfc6d386fbec
Revises: 
Create Date: 2025-09-23 01:16:11.641469

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = 'bfc6d386fbec'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('core_services_country',
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('iso_a2', sa.String(length=2), nullable=False),
    sa.Column('iso_a3', sa.String(length=3), nullable=False),
    sa.Column('iso_n', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_core_services_country')),
    sa.UniqueConstraint('iso_a2', name=op.f('uq_core_services_country_iso_a2')),
    sa.UniqueConstraint('iso_a3', name=op.f('uq_core_services_country_iso_a3')),
    sa.UniqueConstraint('iso_n', name=op.f('uq_core_services_country_iso_n')),
    sa.UniqueConstraint('name', name=op.f('uq_core_services_country_name'))
    )
    op.create_table('core_services_bank',
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('legal_name', sa.String(length=100), nullable=False),
    sa.Column('code', sa.String(length=20), nullable=False),
    sa.Column('swift_code', sa.String(length=11), nullable=False),
    sa.Column('country_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['country_id'], ['core_services_country.pk'], name=op.f('fk_core_services_bank_country_id_core_services_country'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_core_services_bank')),
    sa.UniqueConstraint('code', 'country_id', name='uq_core_services_bank_code_country_id')
    )
    op.create_table('core_services_currency',
    sa.Column('country_id', sa.BigInteger(), nullable=True),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('iso', sa.String(length=3), nullable=False),
    sa.Column('symbol', sa.String(length=5), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['country_id'], ['core_services_country.pk'], name=op.f('fk_core_services_currency_country_id_core_services_country'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_core_services_currency')),
    sa.UniqueConstraint('iso', name=op.f('uq_core_services_currency_iso')),
    sa.UniqueConstraint('name', name=op.f('uq_core_services_currency_name')),
    sa.UniqueConstraint('symbol', name=op.f('uq_core_services_currency_symbol'))
    )
    op.create_table('core_services_phone_code',
    sa.Column('country_id', sa.BigInteger(), nullable=True),
    sa.Column('phone_code', sa.String(length=10), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['country_id'], ['core_services_country.pk'], name=op.f('fk_core_services_phone_code_country_id_core_services_country'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_core_services_phone_code')),
    sa.UniqueConstraint('phone_code', name=op.f('uq_core_services_phone_code_phone_code'))
    )
    op.create_table('core_services_tag',
    sa.Column('name', sa.String(length=150), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_core_services_tag_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_core_services_tag_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_core_services_tag_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_core_services_tag')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_core_services_tag_organization_id'))
    )
    op.create_table('core_services_vat',
    sa.Column('country_id', sa.BigInteger(), nullable=True),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('rate', sa.Numeric(precision=5, scale=4), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['country_id'], ['core_services_country.pk'], name=op.f('fk_core_services_vat_country_id_core_services_country'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_core_services_vat')),
    sa.UniqueConstraint('country_id', 'name', name='uq_core_services_vat_country_id_name')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('core_services_vat')
    op.drop_table('core_services_tag')
    op.drop_table('core_services_phone_code')
    op.drop_table('core_services_currency')
    op.drop_table('core_services_bank')
    op.drop_table('core_services_country')
    # ### end Alembic commands ###
