from fastapi import UploadFile
from sqlalchemy.ext.asyncio import AsyncSession

from be_kit.paginations import PaginationQuery
from be_uam.user.models import User
from ..tag.repositories import TagRepository
from . import enums, schemas, repositories


# Country


async def retrieve_country(db: AsyncSession, pk: int):
    repo = repositories.CountryRepository(db)
    obj = await repo.aget_or_404(pk)
    return obj


async def list_countries(
    db: AsyncSession,
    pagination: PaginationQuery,
    filters: schemas.CountryFilter,
    ordering: list[enums.CountryOrdering] | None,
):
    repo = repositories.CountryRepository(db)
    objs = await repo.arecords(filters, pagination, ordering)
    return objs


# Currency


async def retrieve_currency(db: AsyncSession, pk: int):
    repo = repositories.CurrencyRepository(db)
    obj = await repo.aget_or_404(pk)
    return obj


async def list_currencies(
    db: AsyncSession,
    pagination: PaginationQuery,
    filters: schemas.CurrencyFilter,
    ordering: list[enums.CurrencyOrdering] | None,
):
    repo = repositories.CurrencyRepository(db)
    objs = await repo.arecords(filters, pagination, ordering)
    return objs


# PhoneCode


async def retrieve_phonecode(db: AsyncSession, pk: int):
    repo = repositories.PhoneCodeRepository(db)
    obj = await repo.aget_or_404(pk)
    return obj


async def list_phonecodes(
    db: AsyncSession,
    pagination: PaginationQuery,
    filters: schemas.PhoneCodeFilter,
    ordering: list[enums.PhoneCodeOrdering] | None,
):
    repo = repositories.PhoneCodeRepository(db)
    objs = await repo.arecords(filters, pagination, ordering)
    return objs


# VAT


async def retrieve_vat(db: AsyncSession, pk: int):
    repo = repositories.VATRepository(db)
    obj = await repo.aget_or_404(pk)
    return obj


async def list_vats(
    db: AsyncSession,
    pagination: PaginationQuery,
    filters: schemas.VATFilter,
    ordering: list[enums.VATOrdering] | None,
):
    repo = repositories.VATRepository(db)
    objs = await repo.arecords(filters, pagination, ordering)
    return objs


# Bank


async def retrieve_bank(db: AsyncSession, pk: int):
    repo = repositories.BankRepository(db)
    obj = await repo.aget_or_404(pk)
    return obj


async def list_banks(
    db: AsyncSession,
    pagination: PaginationQuery,
    filters: schemas.BankFilter,
    ordering: list[enums.BankOrdering] | None,
):
    repo = repositories.BankRepository(db)
    objs = await repo.arecords(filters, pagination, ordering)
    return objs
