from enum import Enum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin


class CountryOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    ISO_A2 = "iso_a2"
    ISO_A2_DESC = "-iso_a2"
    ISO_A3 = "iso_a3"
    ISO_A3_DESC = "-iso_a3"
    ISO_N = "iso_n"
    ISO_N_DESC = "-iso_n"


class CurrencyOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    ISO = "iso"
    ISO_DESC = "-iso"
    SYMBOL = "symbol"
    SYMBOL_DESC = "-symbol"


class PhoneCodeOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    PHONE_CODE = "phone_code"
    PHONE_CODE_DESC = "-phone_code"


class VATOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    RATE = "rate"
    RATE_DESC = "-rate"


class BankOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    LEGAL_NAME = "legal_name"
    LEGAL_NAME_DESC = "-legal_name"
    CODE = "code"
    CODE_DESC = "-code"
    SWIFT_CODE = "swift_code"
    SWIFT_CODE_DESC = "-swift_code"
