from sqlalchemy import Select

from be_kit.repositories import BaseRepository
from ..tag.repositories import TagRepositoryMixin
from . import models


class ContactRepository(TagRepositoryMixin, BaseRepository):
    model = models.Contact
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query


class IndustryRepository(BaseRepository):
    model = models.Industry
    filter_by_organization = False


class AddressRepository(BaseRepository):
    model = models.Address
    filter_by_organization = False
