from enum import Enum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin


class ContactLegalType(Enum):
    INDIVIDUAL = "Individual"
    PARTNERSHIP = "Partnership"
    LIMITED_PARTNERSHIP = "Limited Partnership"
    LIMITED_LIABILITY_PARTNERSHIP = "Limited Liability Partnership"
    LIMITED_LIABILITY_COMPANY = "Limited Liability Company"
    PUBLIC_LIMITED_COMPANY = "Public Limited Company"
    PRIVATE_LIMITED_COMPANY = "Private Limited Company"
    CORPORATION = "Corporation"
    NONPROFIT_ORGANIZATION = "Nonprofit Organization"
    COOPERATIVE = "Cooperative"
    TRUST = "Trust"
    GOVERNMENT_AGENCY = "Government Agency"


class ContactIndustryType(Enum):
    AGRICULTURE_FORESTRY_FISHING = "Agriculture, Forestry, and Fishing"
    MINING_QUARRYING = "Mining and Quarrying"
    MANUFACTURING = "Manufacturing"
    UTILITIES = "Utilities (Electricity, Gas, and Water Supply)"
    WATER_SUPPLY_WASTE_MANAGEMENT = "Water Supply, Waste Management, and Remediation"
    CONSTRUCTION = "Construction"
    WHOLESALE_RETAIL_TRADE = "Wholesale and Retail Trade"
    TRANSPORTATION_STORAGE = "Transportation and Storage"
    ACCOMMODATION_FOOD_SERVICE = "Accommodation and Food Service Activities"
    INFORMATION_COMMUNICATION = "Information and Communication"
    FINANCIAL_INSURANCE = "Financial and Insurance Activities"
    REAL_ESTATE = "Real Estate Activities"
    PROFESSIONAL_SCIENTIFIC_TECHNICAL = (
        "Professional, Scientific, and Technical Services"
    )
    ADMINISTRATIVE_SUPPORT = "Administrative and Support Services"
    PUBLIC_ADMINISTRATION = "Public Administration and Defense"
    EDUCATION = "Education"
    HEALTH_SOCIAL_WORK = "Human Health and Social Work Activities"
    ARTS_ENTERTAINMENT_RECREATION = "Arts, Entertainment, and Recreation"
    OTHER_SERVICE_ACTIVITIES = "Other Service Activities"
    HOUSEHOLD_ACTIVITIES = "Activities of Households as Employers"
    EXTRATERRITORIAL_ACTIVITIES = "Activities of Extraterritorial Organizations"


class ContactAddressType(Enum):
    MAIN = "Main"
    BILLING = "Billing"
    SHIPPING = "Shipping"
    OTHER = "Other"


class ContactOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    LEGAL_TYPE = "legal_type"
    LEGAL_TYPE_DESC = "-legal_type"
    TAX_ID = "tax_id"
    TAX_ID_DESC = "-tax_id"
