from be_kit.applications import get_app
from be_uam.application import auth_router
from .settings import settings
from .tag.application import router as tag_router
from .country.application import (
    country_router,
    currency_router,
    phonecode_router,
    vat_router,
    bank_router,
)
from .contact.application import router as contact_router


app = get_app(settings)

if settings.debug:
    app.include_router(auth_router)

app.include_router(tag_router)
app.include_router(country_router)
app.include_router(currency_router)
app.include_router(phonecode_router)
app.include_router(vat_router)
app.include_router(bank_router)
app.include_router(contact_router)
