from pathlib import Path
from typing import Literal

from pydantic import BaseModel, HttpUrl
from pydantic_settings import BaseSettings, SettingsConfigDict


class CoreSettings(BaseSettings):
    model_config = SettingsConfigDict(
        env_file=".env",
        env_prefix="be_",
        extra="ignore",
        env_nested_delimiter="__",
    )
    service_name: str | None = None
    service_shortname: str | None = None
    version: str | None = None
    root_dir: str = str(Path.cwd())
    debug: bool = False
    ssl: bool = False
    secret_key: str | None = None
    host: str | None = None
    port: int | None = None
    allowed_origins: list[str] | None = None
    db_host: str | None = None
    db_port: int | None = None
    db_database: str | None = None
    db_username: str | None = None
    db_password: str | None = None
    n_server_worker: int = 1
    dump_logs: bool = True
    test_mode: bool = False
    max_requests: int = 4
    max_requests_jitter: int = 1
    db_bulk_size: int = 1000


core_settings = CoreSettings()


class CISettings(BaseSettings):
    model_config = SettingsConfigDict(
        env_file=".env",
        env_prefix="be_ci_",
        extra="ignore",
        env_nested_delimiter="__",
    )
    package_registry: HttpUrl | None = None
    auth_username: str | None = None
    auth_token: str | None = None


class RedisSettings(BaseModel):
    host: str | None = None
    port: int | None = None
    database: int | None = None
    default_ttl: int = 60


class MailingSettings(BaseModel):
    smtp_mode: Literal["gmail", "o365", "smtp"] | None = None
    smtp_host: str | None = None
    smtp_port: int | None = None
    smtp_username: str | None = None
    smtp_password: str | None = None
    smtp_from: str | None = None
    smtp_from_name: str | None = None
    smtp_client_id: str | None = None
    smtp_tenant_id: str | None = None
    smtp_client_secret: str | None = None
    verifications_url: HttpUrl | None = None


class TaskSettings(BaseModel):
    queue_names: list[str] | None = None
    ttl: int | None = None


class SFTPSettings(BaseModel):
    base_path: str | None = "symbolix"
    host: str | None = None
    port: int | None = None
    username: str | None = None
    password: str | None = None
