import subprocess
import sys
from pathlib import Path

from loguru import logger

from .settings import CISettings


ci_settings = CISettings()


def build_package():
    subprocess.check_call([sys.executable, "-m", "build"])


def upload_package():

    dist_path = Path("dist")
    if not dist_path.exists():
        raise FileNotFoundError("dist directory not found. Build the package first.")
    files = list(dist_path.glob("*.tar.gz")) + list(dist_path.glob("*.whl"))
    if not files:
        raise FileNotFoundError("No distribution files found in dist/")
    repo_url = ci_settings.package_registry
    username = ci_settings.auth_username
    password = ci_settings.auth_token
    for file in files:
        subprocess.check_call(
            [
                sys.executable,
                "-m",
                "twine",
                "upload",
                "--repository-url",
                str(repo_url),
                "-u",
                username,
                "-p",
                password,
                str(file),
            ]
        )


def main():
    if (
        not ci_settings.package_registry
        or not ci_settings.auth_username
        or not ci_settings.auth_token
    ):
        raise ValueError("CI settings are not properly configured.")

    build_package()
    upload_package()
    logger.info("Package published successfully.")


if __name__ == "__main__":
    try:
        main()
    # pylint: disable=broad-exception-caught
    except Exception as e:
        logger.error(f"Failed to publish package: {e}")
        sys.exit(1)
    # pylint: enable=broad-exception-caught
