from decimal import Decimal


def safe_decimal(value: float | str | Decimal) -> Decimal:
    return Decimal(str(value))


def format_currency(value: float | Decimal, symbol="$", precision=2):
    return f"{symbol} {value:,.{precision}f}"
