import datetime
import random
from decimal import Decimal

import pandas as pd

from be_kit.schemas import BaseSchema


async def get_version_upload_template(
    schema: BaseSchema, orders: list[str] | None = None
):
    columns = list(schema.model_fields.keys())
    df = pd.DataFrame(columns=columns)
    if orders:
        df = df.reindex(columns=orders)
    example_row = {}
    for field_name, model_field in schema.model_fields.items():
        field_type = model_field.annotation

        if field_type == str:
            value = f"example_{field_name}"
        elif field_type == int:
            value = random.randint(1, 10)
        elif field_type in [float, Decimal]:
            value = round(random.random() * 100, 2)
        elif field_type == bool:
            value = True
        elif field_type == datetime.date:
            value = datetime.date(2000, 1, 1)
        elif field_type == datetime.datetime:
            value = datetime.datetime(2000, 1, 1, 12, 0, 0)
        else:
            value = None

        example_row[field_name] = value

    if orders:
        example_row = {col: example_row.get(col) for col in orders}

    df.loc[0] = example_row
    return df
