from fastapi import HTTPException


HTTPNotFoundException = HTTPException(
    status_code=404,
    detail="Object not found.",
)

HTTPNotAuthenticatedException = HTTPException(
    status_code=401,
    detail="Not authenticated.",
    headers={"WWW-Authenticate": "Bearer"},
)


HTTPUnauthorizedException = HTTPException(
    status_code=401,
    detail="Unauthorized access.",
    headers={"WWW-Authenticate": "Bearer"},
)
