from enum import Enum, EnumMeta, StrEnum


class TaskStatus(Enum):
    QUEUED = "Queued"
    RUNNING = "Running"
    SUCCESS = "Success"
    FAILED = "Failed"
    CANCELLING = "Cancelling"
    CANCELLED = "Cancelled"
    STOPPING = "Stopping"
    STOPPED = "Stopped"
    TIMEOUT = "Timeout"
    UNKNOWN = "Unknown"


class MixinEnumMeta(EnumMeta):
    def __new__(mcs, clsname, bases, clsdict, **kwds):
        def collect_uppercase_attrs(base):
            attrs = {}
            if base is not StrEnum and base is not object:
                for k, v in base.__dict__.items():
                    if k.isupper():
                        attrs[k] = v
                for parent in base.__bases__:
                    attrs.update(collect_uppercase_attrs(parent))
            return attrs

        for base in bases:
            if not issubclass(base, StrEnum):
                attrs = collect_uppercase_attrs(base)
                for k, v in attrs.items():
                    if k not in clsdict:
                        clsdict[k] = v
        return super().__new__(mcs, clsname, bases, clsdict, **kwds)


class StrEnumWithMixins(StrEnum, metaclass=MixinEnumMeta):
    pass
