# pylint: disable=unused-import
# pylint: disable=wrong-import-order
# pylint: disable=ungrouped-imports
from uvicorn.workers import UvicornWorker

from ..logging import StubbedGunicornLogger
from ..settings import CoreSettings
from .workers import RestartableUvicornWorker

# pylint: enable=unused-import
# pylint: enable=wrong-import-order
# pylint: enable=ungrouped-imports


def get_options(settings: CoreSettings, binary_mode: bool = False):
    return {
        "bind": f"{settings.host}:{settings.port}",
        "workers": settings.n_server_worker,
        "accesslog": "-",
        "errorlog": "-",
        "worker_class": (
            "be_kit.applications.workers.RestartableUvicornWorker"
            if settings.debug
            else "uvicorn.workers.UvicornWorker"
        ),
        "logger_class": StubbedGunicornLogger,
        "reload": settings.debug and not binary_mode,
        "max_requests": settings.max_requests,
        "max_requests_jitter": settings.max_requests_jitter,
    }
