"""accounting: added journal entry type

Revision ID: 5de563bed1b6
Revises: 1bfcd4951c08
Create Date: 2026-01-07 11:19:14.772739

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = '5de563bed1b6'
down_revision: Union[str, None] = '1bfcd4951c08'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('accounting_bank_reconcile', 'journal_entry_id',
               existing_type=mysql.BIGINT(),
               nullable=True)
    op.drop_constraint('fk_accounting_bank_reconcile_journal_entry_id_accounting_b749', 'accounting_bank_reconcile', type_='foreignkey')
    op.create_foreign_key(op.f('fk_accounting_bank_reconcile_journal_entry_id_accounting_journal_entry'), 'accounting_bank_reconcile', 'accounting_journal_entry', ['journal_entry_id'], ['pk'], ondelete='SET NULL')
    op.add_column('accounting_journal_entry', sa.Column('entry_type', sa.Enum('SALES', 'PURCHASE', 'PRODUCT', 'BANK', name='entrytypeenum'), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('accounting_journal_entry', 'entry_type')
    op.drop_constraint(op.f('fk_accounting_bank_reconcile_journal_entry_id_accounting_journal_entry'), 'accounting_bank_reconcile', type_='foreignkey')
    op.create_foreign_key('fk_accounting_bank_reconcile_journal_entry_id_accounting_b749', 'accounting_bank_reconcile', 'accounting_journal_entry', ['journal_entry_id'], ['pk'], ondelete='CASCADE')
    op.alter_column('accounting_bank_reconcile', 'journal_entry_id',
               existing_type=mysql.BIGINT(),
               nullable=False)
    # ### end Alembic commands ###
