"""accounting: updated account mapping

Revision ID: 1bfcd4951c08
Revises: 36a2b30d356b
Create Date: 2026-01-07 09:21:16.432293

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '1bfcd4951c08'
down_revision: Union[str, None] = '36a2b30d356b'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('accounting_coa_account_mapping', sa.Column('outstanding_payments_account_id', sa.BigInteger(), nullable=True))
    op.add_column('accounting_coa_account_mapping', sa.Column('vat_in_account_id', sa.BigInteger(), nullable=True))
    op.create_foreign_key(op.f('fk_accounting_coa_account_mapping_outstanding_payments_account_id_accounting_coa_account'), 'accounting_coa_account_mapping', 'accounting_coa_account', ['outstanding_payments_account_id'], ['pk'], ondelete='CASCADE')
    op.create_foreign_key(op.f('fk_accounting_coa_account_mapping_vat_in_account_id_accounting_coa_account'), 'accounting_coa_account_mapping', 'accounting_coa_account', ['vat_in_account_id'], ['pk'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('fk_accounting_coa_account_mapping_vat_in_account_id_accounting_coa_account'), 'accounting_coa_account_mapping', type_='foreignkey')
    op.drop_constraint(op.f('fk_accounting_coa_account_mapping_outstanding_payments_account_id_accounting_coa_account'), 'accounting_coa_account_mapping', type_='foreignkey')
    op.drop_column('accounting_coa_account_mapping', 'vat_in_account_id')
    op.drop_column('accounting_coa_account_mapping', 'outstanding_payments_account_id')
    # ### end Alembic commands ###
