"""accounting: added sales and purchase discount to account mapping

Revision ID: 016d1f24d545
Revises: 720adc631e4c
Create Date: 2026-01-03 10:14:31.007621

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '016d1f24d545'
down_revision: Union[str, None] = '720adc631e4c'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('accounting_coa_account_mapping', sa.Column('sales_discount_account_id', sa.BigInteger(), nullable=True))
    op.add_column('accounting_coa_account_mapping', sa.Column('purchase_discount_account_id', sa.BigInteger(), nullable=True))
    op.create_foreign_key(op.f('fk_accounting_coa_account_mapping_sales_discount_account_id_accounting_coa_account'), 'accounting_coa_account_mapping', 'accounting_coa_account', ['sales_discount_account_id'], ['pk'], ondelete='CASCADE')
    op.create_foreign_key(op.f('fk_accounting_coa_account_mapping_purchase_discount_account_id_accounting_coa_account'), 'accounting_coa_account_mapping', 'accounting_coa_account', ['purchase_discount_account_id'], ['pk'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('fk_accounting_coa_account_mapping_purchase_discount_account_id_accounting_coa_account'), 'accounting_coa_account_mapping', type_='foreignkey')
    op.drop_constraint(op.f('fk_accounting_coa_account_mapping_sales_discount_account_id_accounting_coa_account'), 'accounting_coa_account_mapping', type_='foreignkey')
    op.drop_column('accounting_coa_account_mapping', 'purchase_discount_account_id')
    op.drop_column('accounting_coa_account_mapping', 'sales_discount_account_id')
    # ### end Alembic commands ###
