"""accounting: added account payable to mapping

Revision ID: 720adc631e4c
Revises: 54f0b241a37a
Create Date: 2025-12-09 09:10:52.299058

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '720adc631e4c'
down_revision: Union[str, None] = '54f0b241a37a'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_foreign_key(op.f('fk_accounting_bank_reconcile_organization_id_uam_organization'), 'accounting_bank_reconcile', 'uam_organization', ['organization_id'], ['pk'], ondelete='RESTRICT')
    op.add_column('accounting_coa_account_mapping', sa.Column('account_payable_id', sa.BigInteger(), nullable=False))
    op.create_foreign_key(op.f('fk_accounting_coa_account_mapping_account_payable_id_accounting_coa_account'), 'accounting_coa_account_mapping', 'accounting_coa_account', ['account_payable_id'], ['pk'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('fk_accounting_coa_account_mapping_account_payable_id_accounting_coa_account'), 'accounting_coa_account_mapping', type_='foreignkey')
    op.drop_column('accounting_coa_account_mapping', 'account_payable_id')
    op.drop_constraint(op.f('fk_accounting_bank_reconcile_organization_id_uam_organization'), 'accounting_bank_reconcile', type_='foreignkey')
    # ### end Alembic commands ###
