"""accounting: fixed alembic for bank recon

Revision ID: 54f0b241a37a
Revises: 35aae4a09648
Create Date: 2025-12-04 08:24:12.574188

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '54f0b241a37a'
down_revision: Union[str, None] = '35aae4a09648'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Drop the foreign key constraint first
    op.drop_constraint('fk_accounting_bank_reconcile_organization_id_uam_organization', 'accounting_bank_reconcile', type_='foreignkey')
    # Now drop the index
    op.drop_index('uq_accounting_bank_reconcile_organization_id', table_name='accounting_bank_reconcile')
    # ### end Alembic commands ###

def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index('uq_accounting_bank_reconcile_organization_id', 'accounting_bank_reconcile', ['organization_id'], unique=True)
    op.create_foreign_key('fk_accounting_bank_reconcile_organization_id_uam_organization', 'accounting_bank_reconcile', 'uam_organization', ['organization_id'], ['id'])
    # ### end Alembic commands ###
