"""accounting: updated bank recon status

Revision ID: 35aae4a09648
Revises: bd4ce289a144
Create Date: 2025-12-03 12:12:21.442078

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '35aae4a09648'
down_revision: Union[str, None] = 'bd4ce289a144'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('accounting_bank_reconcile', sa.Column('status', sa.Enum('DRAFT', 'POSTED', 'VALIDATED', name='bankreconstatus'), nullable=True))
    op.create_index(op.f('ix_accounting_bank_reconcile_status'), 'accounting_bank_reconcile', ['status'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_accounting_bank_reconcile_status'), table_name='accounting_bank_reconcile')
    op.drop_column('accounting_bank_reconcile', 'status')
    # ### end Alembic commands ###
