"""accounting: updated bank statement

Revision ID: 6bdac25c519e
Revises: 64ffb15c1921
Create Date: 2025-11-29 11:30:53.320161

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '6bdac25c519e'
down_revision: Union[str, None] = '64ffb15c1921'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    # Drop the foreign key constraint first
    op.drop_constraint('fk_accounting_bank_statement_organization_id_uam_organization', 'accounting_bank_statement', type_='foreignkey')
    # Now drop the unique index
    op.drop_index('uq_accounting_bank_statement_organization_id', table_name='accounting_bank_statement')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index('uq_accounting_bank_statement_organization_id', 'accounting_bank_statement', ['organization_id'], unique=True)
    # ### end Alembic commands ###
