"""accounting: updated bank statement

Revision ID: 64ffb15c1921
Revises: 5ef9e2fead83
Create Date: 2025-11-29 11:19:56.468116

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '64ffb15c1921'
down_revision: Union[str, None] = '5ef9e2fead83'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('accounting_bank_statement',
    sa.Column('bank_account_id', sa.BigInteger(), nullable=False),
    sa.Column('statement_date', sa.Date(), nullable=False),
    sa.Column('opening_balance', be_kit.databases.NominalField(precision=30, scale=15), nullable=True),
    sa.Column('closing_balance', be_kit.databases.NominalField(precision=30, scale=15), nullable=True),
    sa.Column('period_start', sa.Date(), nullable=False),
    sa.Column('period_end', sa.Date(), nullable=False),
    sa.Column('total_debit', sa.Integer(), nullable=True),
    sa.Column('total_credit', sa.Integer(), nullable=True),
    sa.Column('remark', sa.String(length=500), nullable=True),
    sa.Column('status', sa.Enum('DRAFT', 'IMPORTED', name='bankstatementstatus'), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['bank_account_id'], ['accounting_bank_account.pk'], name=op.f('fk_accounting_bank_statement_bank_account_id_accounting_bank_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_bank_statement_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_bank_statement_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_accounting_bank_statement_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_accounting_bank_statement')),
    sa.UniqueConstraint('organization_id', name=op.f('uq_accounting_bank_statement_organization_id'))
    )
    op.create_index(op.f('ix_accounting_bank_statement_status'), 'accounting_bank_statement', ['status'], unique=False)
    op.create_table('accounting_bank_statement_line',
    sa.Column('bank_statement_id', sa.BigInteger(), nullable=False),
    sa.Column('transaction_date', sa.Date(), nullable=False),
    sa.Column('description', sa.String(length=500), nullable=True),
    sa.Column('reference_number', sa.String(length=100), nullable=True),
    sa.Column('amount', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('is_reconciled', sa.Boolean(), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['bank_statement_id'], ['accounting_bank_statement.pk'], name=op.f('fk_accounting_bank_statement_line_bank_statement_id_accounting_bank_statement'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_bank_statement_line_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_bank_statement_line_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_accounting_bank_statement_line_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_accounting_bank_statement_line'))
    )
    op.create_table('accounting_bank_reconcile',
    sa.Column('bank_statement_line_id', sa.BigInteger(), nullable=False),
    sa.Column('journal_entry_id', sa.BigInteger(), nullable=False),
    sa.Column('matched_amount', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('status', sa.Enum('FULL', 'PARTIAL', name='bankreconstatus'), nullable=True),
    sa.Column('matched_at', sa.DateTime(), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['bank_statement_line_id'], ['accounting_bank_statement_line.pk'], name=op.f('fk_accounting_bank_reconcile_bank_statement_line_id_accounting_bank_statement_line'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_bank_reconcile_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['journal_entry_id'], ['accounting_journal_entry.pk'], name=op.f('fk_accounting_bank_reconcile_journal_entry_id_accounting_journal_entry'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_bank_reconcile_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_accounting_bank_reconcile_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_accounting_bank_reconcile')),
    sa.UniqueConstraint('organization_id', name=op.f('uq_accounting_bank_reconcile_organization_id'))
    )
    op.create_index(op.f('ix_accounting_bank_reconcile_status'), 'accounting_bank_reconcile', ['status'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_accounting_bank_reconcile_status'), table_name='accounting_bank_reconcile')
    op.drop_table('accounting_bank_reconcile')
    op.drop_table('accounting_bank_statement_line')
    op.drop_index(op.f('ix_accounting_bank_statement_status'), table_name='accounting_bank_statement')
    op.drop_table('accounting_bank_statement')
    # ### end Alembic commands ###
