"""accounting: intitial migrations

Revision ID: 5ef9e2fead83
Revises:
Create Date: 2025-11-25 13:36:27.235292

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '5ef9e2fead83'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('accounting_coa_account_category',
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.String(length=500), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_coa_account_category_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_coa_account_category_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_accounting_coa_account_category_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_accounting_coa_account_category')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_accounting_coa_account_category_organization_id'))
    )
    op.create_index(op.f('ix_accounting_coa_account_category_name'), 'accounting_coa_account_category', ['name'], unique=False)
    op.create_table('accounting_coa_account',
    sa.Column('account_number', sa.String(length=20), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('currency_id', sa.BigInteger(), nullable=False),
    sa.Column('balance', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_coa_account_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['currency_id'], ['core_services_currency.pk'], name=op.f('fk_accounting_coa_account_currency_id_core_services_currency'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_coa_account_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_accounting_coa_account_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_accounting_coa_account')),
    sa.UniqueConstraint('organization_id', 'account_number', name=op.f('uq_accounting_coa_account_organization_id'))
    )
    op.create_table('accounting_journal_counter',
    sa.Column('counter_date', sa.Date(), nullable=False),
    sa.Column('counter', sa.BigInteger(), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_accounting_journal_counter_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_accounting_journal_counter')),
    sa.UniqueConstraint('organization_id', 'counter_date', name=op.f('uq_accounting_journal_counter_organization_id'))
    )
    op.create_index(op.f('ix_accounting_journal_counter_counter_date'), 'accounting_journal_counter', ['counter_date'], unique=False)
    op.create_table('accounting_bank_account',
    sa.Column('account_number', sa.String(length=20), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('bank_id', sa.BigInteger(), nullable=False),
    sa.Column('currency_id', sa.BigInteger(), nullable=False),
    sa.Column('account_id', sa.BigInteger(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_bank_account_account_id_accounting_coa_account'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['bank_id'], ['core_services_bank.pk'], name=op.f('fk_accounting_bank_account_bank_id_core_services_bank'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_bank_account_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['currency_id'], ['core_services_currency.pk'], name=op.f('fk_accounting_bank_account_currency_id_core_services_currency'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_bank_account_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_accounting_bank_account_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_accounting_bank_account')),
    sa.UniqueConstraint('organization_id', 'account_number', name=op.f('uq_accounting_bank_account_organization_id'))
    )
    op.create_table('accounting_coa_account_mapping',
    sa.Column('outstanding_receipts_account_id', sa.BigInteger(), nullable=False),
    sa.Column('sales_advance_account_id', sa.BigInteger(), nullable=False),
    sa.Column('cost_of_revenue_account_id', sa.BigInteger(), nullable=False),
    sa.Column('account_receivable_account_id', sa.BigInteger(), nullable=False),
    sa.Column('account_payable_account_id', sa.BigInteger(), nullable=False),
    sa.Column('revenue_account_id', sa.BigInteger(), nullable=False),
    sa.Column('vat_out_account_id', sa.BigInteger(), nullable=False),
    sa.Column('advance_account_id', sa.BigInteger(), nullable=False),
    sa.Column('sales_return_account_id', sa.BigInteger(), nullable=False),
    sa.Column('default_inventory_account_id', sa.BigInteger(), nullable=True),
    sa.Column('default_bank_account_account_id', sa.BigInteger(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['account_payable_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_account_payable_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['account_receivable_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_account_receivable_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['advance_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_advance_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['cost_of_revenue_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_cost_of_revenue_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_coa_account_mapping_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['default_bank_account_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_default_bank_account_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['default_inventory_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_default_inventory_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_accounting_coa_account_mapping_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_accounting_coa_account_mapping_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['outstanding_receipts_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_outstanding_receipts_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['revenue_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_revenue_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['sales_advance_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_sales_advance_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['sales_return_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_sales_return_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['vat_out_account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_coa_account_mapping_vat_out_account_id_accounting_coa_account'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_accounting_coa_account_mapping')),
    sa.UniqueConstraint('organization_id', name=op.f('uq_accounting_coa_account_mapping_organization_id'))
    )
    op.create_table('accounting_journal_entry_item',
    sa.Column('entry_id', sa.BigInteger(), nullable=False),
    sa.Column('account_id', sa.BigInteger(), nullable=False),
    sa.Column('side', sa.Enum('DEBIT', 'CREDIT', name='entryside'), nullable=False),
    sa.Column('amount', be_kit.databases.NominalField(precision=30, scale=15), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['account_id'], ['accounting_coa_account.pk'], name=op.f('fk_accounting_journal_entry_item_account_id_accounting_coa_account'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['entry_id'], ['accounting_journal_entry.pk'], name=op.f('fk_accounting_journal_entry_item_entry_id_accounting_journal_entry'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_accounting_journal_entry_item')),
    sa.UniqueConstraint('entry_id', 'account_id', name=op.f('uq_accounting_journal_entry_item_entry_id'))
    )
    op.add_column('accounting_coa_account', sa.Column('account_type', sa.Enum('ASSET', 'LIABILITY', 'EQUITY', 'REVENUE', 'EXPENSE', name='accounttypeenum'), nullable=False))
    op.add_column('accounting_coa_account', sa.Column('category_id', sa.BigInteger(), nullable=True))
    op.create_foreign_key(op.f('fk_accounting_coa_account_category_id_accounting_coa_account_category'), 'accounting_coa_account', 'accounting_coa_account_category', ['category_id'], ['pk'], ondelete='RESTRICT')
    op.add_column('accounting_journal_entry', sa.Column('status', sa.Enum('DRAFT', 'POSTED', 'CANCELLED', name='entrystatusenum'), nullable=False))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('accounting_journal_entry', 'status')
    op.drop_constraint(op.f('fk_accounting_coa_account_category_id_accounting_coa_account_category'), 'accounting_coa_account', type_='foreignkey')
    op.drop_column('accounting_coa_account', 'category_id')
    op.drop_column('accounting_coa_account', 'account_type')
    op.drop_table('accounting_journal_entry_item')
    op.drop_table('accounting_coa_account_mapping')
    op.drop_table('accounting_bank_account')
    op.drop_index(op.f('ix_accounting_journal_counter_counter_date'), table_name='accounting_journal_counter')
    op.drop_table('accounting_journal_counter')
    op.drop_index(op.f('ix_accounting_coa_account_category_name'), table_name='accounting_coa_account_category')
    op.drop_table('accounting_coa_account_category')
    # ### end Alembic commands ###
