from enum import Enum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin


class EntryStatusEnum(StrEnumWithMixins):
    DRAFT = "DRAFT"
    APPROVED = "APPROVED"
    POSTED = "POSTED"
    CANCELLED = "CANCELLED"

class EntryTypeEnum(StrEnumWithMixins):
    SALES = "SALES"
    PURCHASE = "PURCHASE"
    PRODUCT = "PRODUCT"
    BANK = "BANK"


class EntrySide(Enum):
    DEBIT = "debit"
    CREDIT = "credit"


class EntryOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    IDENTIFIER = "identifier"
    IDENTIFIER_DESC = "-identifier"
