from sqlalchemy import select, Select

from be_kit.repositories import BaseRepository
from . import models

class AccountCategoryRepository(BaseRepository):
    model = models.AccountCategory
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query

    async def find_by_name_and_org(self, name: str, organization_id: int):
        stmt = select(self.model).where(
            self.model.name == name,
            self.model.organization_id == organization_id
        )
        result = await self.session.execute(stmt)
        return result.scalar_one_or_none()


class AccountRepository(BaseRepository):
    model = models.Account
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query

    async def find_by_number_and_org(self, account_number: str, organization_id: int):
        stmt = select(self.model).where(
            self.model.account_number == account_number,
            self.model.organization_id == organization_id,
        )
        result = await self.session.execute(stmt)
        return result.scalar_one_or_none()


class AccountMappingRepository(BaseRepository):
    model = models.AccountMapping
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query
