from be_uam.permission.utils import generate_permission_list

permissions = generate_permission_list(
    app="accounting",
    module="coa",
    submodule="account_category",
    action=[
        "create",
        "read",
        "update",
        "delete",
    ],
)


account_category_permission_mapper = {
    "create_account_category": ["accounting.coa.account_category.create"],
    "retrieve_account_category": ["accounting.coa.account_category.read"],
    "update_account_category": ["accounting.coa.account_category.update"],
    "list_account_category": ["accounting.coa.account_category.read"],
    "list_account_category_option": ["accounting.coa.account_category.read"],
    "delete_account_category": ["accounting.coa.account_category.delete"],
}

permissions += generate_permission_list(
    app="accounting",
    module="coa",
    submodule="account",
    action=[
        "create",
        "read",
        "update",
        "delete",
    ],
)


account_permission_mapper = {
    "create_account": ["accounting.coa.account.create"],
    "retrieve_account": ["accounting.coa.account.read"],
    "update_account": ["accounting.coa.account.update"],
    "list_account": ["accounting.coa.account.read"],
    "list_account_option": ["accounting.coa.account.read"],
    "delete_account": ["accounting.coa.account.delete"],
    "download_upload_account_template": ["accounting.coa.account.create"],
    "upload_account": ["accounting.coa.account.create"],
    "download_account": ["accounting.coa.account.read"],
}


permissions += generate_permission_list(
    app="accounting",
    module="coa",
    submodule="account_mapping",
    action=[
        "create",
        "read",
        "update",
        "delete",
    ],
)


account_mapping_permission_mapper = {
    "create_account_mapping": ["accounting.coa.account_mapping.create"],
    "retrieve_account_mapping": ["accounting.coa.account_mapping.read"],
    "update_account_mapping": ["accounting.coa.account_mapping.update"],
    "list_account_mappings": ["accounting.coa.account_mapping.read"],
    "delete_account_mapping": ["accounting.coa.account_mapping.delete"],
}
