from enum import Enum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin

class AccountCategoryOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    NAME = "name"
    NAME_DESC = "-name"
    DESCRIPTION = "description"
    DESCRIPTION_DESC = "-description"

class AccountTypeEnum(StrEnumWithMixins):
    ASSET = "Asset"
    LIABILITY = "Liability"
    EQUITY = "Equity"
    REVENUE = "Revenue"
    EXPENSE = "Expense"


class AccountOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    ACCOUNT_NUMBER = "account_number"
    ACCOUNT_NUMBER_DESC = "-account_number"
    NAME = "name"
    NAME_DESC = "-name"
    BALANCE = "balance"
    BALANCE_DESC = "-balance"
