from sqlalchemy import Select, select

from be_kit.repositories import BaseRepository
from . import models


class BankStatementRepository(BaseRepository):
    model = models.BankStatement
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query


class BankStatementLineRepository(BaseRepository):
    model = models.BankStatementLine
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query

    async def alist_by_statement_id(self, bank_statement_id: int):
        stmt = select(self.model).where(
            self.model.bank_statement_id == bank_statement_id,
            self.model.organization_id == self.organization_id
        )
        result = await self.session.execute(stmt)
        return result.scalars().all()

class BankReconcileRepository(BaseRepository):
    model = models.BankReconcile
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query
