from enum import Enum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin

class BankStatementStatus(Enum):
    DRAFT = "draft"
    IMPORTED = "imported"


class BankReconStatus(Enum):
    DRAFT = "draft"
    POSTED = "posted"
    VALIDATED = "validated"


class BankStatementOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    STATEMENT_DATE = "statement_date"
    STATEMENT_DATE_DESC = "-statement_date"
    REMARK = "remark"
    REMARK_DESC = "-remark"

class BankStatementLineOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    TRANSACTION_DATE = "transaction_date"
    TRANSACTION_DATE_DESC = "-transaction_date"
    AMOUNT = "amount"
