from sqlalchemy import Select

from be_kit.repositories import BaseRepository
from . import models


class BankAccountRepository(BaseRepository):
    model = models.BankAccount
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query
