from decimal import Decimal

from sqlalchemy import (
    BigInteger,
    Enum,
    ForeignKey,
    String,
    UniqueConstraint,
)
from sqlalchemy.orm import Mapped, declared_attr, mapped_column, relationship

from be_kit.databases import BaseModel, SoftDeleteMixin, NominalField
from be_uam.kit.models import MetadataMixin, OrganizationMixin
from be_uam.user.models import User
from be_core_services.country.models import Bank, Currency
from be_core_services.tag.models import Tag
from ..coa.models import Account
from . import enums


class BankAccount(SoftDeleteMixin, OrganizationMixin, MetadataMixin, BaseModel):
    __tablename__ = "accounting_bank_account"
    __table_args__ = (UniqueConstraint("organization_id", "account_number"),)

    account_number: Mapped[str] = mapped_column(String(20))
    name: Mapped[str] = mapped_column(String(100))
    bank_id: Mapped[int] = mapped_column(
        ForeignKey("core_services_bank.pk", ondelete="RESTRICT"),
    )
    bank: Mapped[Bank] = relationship(
        "Bank",
        passive_deletes=True,
        lazy="selectin",
    )
    currency_id: Mapped[int] = mapped_column(
        ForeignKey("core_services_currency.pk", ondelete="RESTRICT"),
    )
    currency: Mapped[Currency] = relationship(
        "Currency",
        passive_deletes=True,
        lazy="selectin",
    )
    account_id: Mapped[int | None] = mapped_column(
        ForeignKey(f"{Account.__tablename__}.pk", ondelete="SET NULL"),
        nullable=True,
        default=None,
    )
    account: Mapped[Account | None] = relationship(
        "Account",
        passive_deletes=True,
        lazy="selectin",
    )
