from be_kit.applications import get_app
from be_uam.application import auth_router
from .settings import settings
from .coa.application import account_router, account_category_router, account_mapping_router
from .bank_account.application import router as bank_account_router
from .journal.application import router as journal_router
from .bank_reconcile.application import bank_statement_router, bank_statement_line_router, bank_reconcile_router


app = get_app(settings)

if settings.debug:
    app.include_router(auth_router)

app.include_router(account_router)
app.include_router(account_category_router)
app.include_router(account_mapping_router)
app.include_router(bank_account_router)
app.include_router(journal_router)
app.include_router(bank_statement_router)
app.include_router(bank_statement_line_router)
app.include_router(bank_reconcile_router)
