from typing_extensions import Annotated

from fastapi import File, UploadFile
from pydantic import EmailStr, PositiveInt, StringConstraints
from pydantic_extra_types.phone_numbers import PhoneNumber

from be_kit.paginations import BasePaginatedResponse
from be_kit.schemas import BaseSchema, BaseORMSchema
from be_uam.kit.schemas import MetadataMixin
from be_uam.user.schemas import UserMin
from be_core_services.tag.schemas import TagListMixin, TagListWriteMixin
from . import enums


# Member


class MemberWrite(BaseSchema):
    user_id: PositiveInt


class Member(BaseORMSchema):
    user: UserMin


# SalesTeam

class BaseSalesTeam:
    name: Annotated[str, StringConstraints(min_length=1, max_length=100)]
    description: Annotated[str | None, StringConstraints(min_length=1, max_length=500)]
    expected_revenue: Annotated[str | None, StringConstraints(min_length=1, max_length=100)]


class SalesTeamCreate(TagListWriteMixin, BaseSalesTeam, BaseSchema):
    leader_id: PositiveInt
    members: list[MemberWrite]


class SalesTeamUpdate(TagListWriteMixin, BaseSalesTeam, BaseSchema):
    leader_id: PositiveInt
    members: list[MemberWrite]


class SalesTeam(TagListMixin, MetadataMixin, BaseSalesTeam, BaseORMSchema):
    leader: UserMin
    members: list[Member]


class PaginatedSalesTeam(BasePaginatedResponse):
    items: list[SalesTeam]


class SalesTeamFilter(BaseSchema):
    name: str | None = None
    name__icontains: str | None = None
    description: str | None = None
    description__icontains: str | None = None
    leader_id: PositiveInt | None = None


class SalesTeamMin(BaseSalesTeam, BaseORMSchema):
    pass


class SalesTeamOpt(SalesTeamMin):
    pass


class PaginatedSalesTeamOpt(BasePaginatedResponse):
    items: list[SalesTeamOpt]


UserMin.model_rebuild()
