from sqlalchemy import Select

from be_kit.repositories import BaseRepository
from be_kit.exceptions import HTTPNotFoundException
from be_core_services.tag.repositories import TagRepositoryMixin
from . import models


class SalesTeamRepository(TagRepositoryMixin, BaseRepository):
    model = models.SalesTeam
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query

    async def aget_by_user(self, user_id: int):
        query = (
            self.session.query(self.model)
            .join(models.Member)
            .filter(
                (models.Member.user_id == user_id) | (self.model.leader_id == user_id)
            )
        )
        if self.filter_by_organization and self.organization_id is not None:
            query = query.filter(self.model.organization_id == self.organization_id)
        result = await self.session.execute(query)
        obj = result.scalar_one_or_none()
        if obj is None:
            raise HTTPNotFoundException
        return obj


class MemberRepository(BaseRepository):
    model = models.Member
    filter_by_organization = False
