"""crm: added sales_person_id

Revision ID: 86c92f382482
Revises: 01f4f1a23400
Create Date: 2025-10-01 04:06:57.854469

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '86c92f382482'
down_revision: Union[str, None] = '01f4f1a23400'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('crm_lead', sa.Column('sales_person_id', sa.BigInteger(), nullable=False))
    op.create_foreign_key(op.f('fk_crm_lead_sales_person_id_uam_user'), 'crm_lead', 'uam_user', ['sales_person_id'], ['pk'], ondelete='RESTRICT')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('fk_crm_lead_sales_person_id_uam_user'), 'crm_lead', type_='foreignkey')
    op.drop_column('crm_lead', 'sales_person_id')
    # ### end Alembic commands ###
