"""crm: populate initial permissions

Revision ID: 01f4f1a23400
Revises: 9e370fbfe3da
Create Date: 2025-09-25 19:58:05.041373

"""

from typing import Sequence, Union

from alembic import op
from sqlalchemy.orm import Session
from be_uam.permission.utils import populate_permissions
from be_crm.permissions import permissions


# revision identifiers, used by Alembic.
revision: str = "01f4f1a23400"
down_revision: Union[str, None] = "9e370fbfe3da"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    db = Session(bind=op.get_bind())
    populate_permissions(db, permissions)
    db.close()


def downgrade() -> None:
    pass
