"""crm: initial migrations

Revision ID: 9e370fbfe3da
Revises: 
Create Date: 2025-09-25 19:57:19.906036

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import be_kit.databases


# revision identifiers, used by Alembic.
revision: str = '9e370fbfe3da'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('crm_lead_counter',
    sa.Column('counter_date', sa.Date(), nullable=False),
    sa.Column('counter', sa.BigInteger(), nullable=False),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_crm_lead_counter_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_crm_lead_counter')),
    sa.UniqueConstraint('organization_id', 'counter_date', name=op.f('uq_crm_lead_counter_organization_id'))
    )
    op.create_index(op.f('ix_crm_lead_counter_counter_date'), 'crm_lead_counter', ['counter_date'], unique=False)
    op.create_table('crm_sales_team',
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.String(length=500), nullable=True),
    sa.Column('leader_id', sa.BigInteger(), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_crm_sales_team_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_crm_sales_team_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['leader_id'], ['uam_user.pk'], name=op.f('fk_crm_sales_team_leader_id_uam_user'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_crm_sales_team_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_crm_sales_team')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_crm_sales_team_organization_id'))
    )
    op.create_table('crm_customer',
    sa.Column('contact_id', sa.BigInteger(), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['contact_id'], ['core_services_contact.pk'], name=op.f('fk_crm_customer_contact_id_core_services_contact'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_crm_customer_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_crm_customer_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_crm_customer_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_crm_customer')),
    sa.UniqueConstraint('organization_id', 'contact_id', name=op.f('uq_crm_customer_organization_id'))
    )
    op.create_table('crm_sales_team_member',
    sa.Column('sales_team_id', sa.BigInteger(), nullable=False),
    sa.Column('user_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['sales_team_id'], ['crm_sales_team.pk'], name=op.f('fk_crm_sales_team_member_sales_team_id_crm_sales_team'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['user_id'], ['uam_user.pk'], name=op.f('fk_crm_sales_team_member_user_id_uam_user'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('sales_team_id', 'pk', name=op.f('pk_crm_sales_team_member')),
    sa.UniqueConstraint('sales_team_id', 'user_id', name=op.f('uq_crm_sales_team_member_sales_team_id'))
    )
    op.create_table('crm_sales_team_tag',
    sa.Column('sales_team_id', sa.BigInteger(), nullable=False),
    sa.Column('tag_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['sales_team_id'], ['crm_sales_team.pk'], name=op.f('fk_crm_sales_team_tag_sales_team_id_crm_sales_team'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['tag_id'], ['core_services_tag.pk'], name=op.f('fk_crm_sales_team_tag_tag_id_core_services_tag'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_crm_sales_team_tag')),
    sa.UniqueConstraint('sales_team_id', 'tag_id', name=op.f('uq_crm_sales_team_tag_sales_team_id'))
    )
    op.create_index(op.f('ix_crm_sales_team_tag_sales_team_id'), 'crm_sales_team_tag', ['sales_team_id'], unique=False)
    op.create_index(op.f('ix_crm_sales_team_tag_tag_id'), 'crm_sales_team_tag', ['tag_id'], unique=False)
    op.create_table('crm_customer_tag',
    sa.Column('customer_id', sa.BigInteger(), nullable=False),
    sa.Column('tag_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['customer_id'], ['crm_customer.pk'], name=op.f('fk_crm_customer_tag_customer_id_crm_customer'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['tag_id'], ['core_services_tag.pk'], name=op.f('fk_crm_customer_tag_tag_id_core_services_tag'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_crm_customer_tag')),
    sa.UniqueConstraint('customer_id', 'tag_id', name=op.f('uq_crm_customer_tag_customer_id'))
    )
    op.create_index(op.f('ix_crm_customer_tag_customer_id'), 'crm_customer_tag', ['customer_id'], unique=False)
    op.create_index(op.f('ix_crm_customer_tag_tag_id'), 'crm_customer_tag', ['tag_id'], unique=False)
    op.create_table('crm_lead',
    sa.Column('identifier', sa.String(length=10), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.String(length=500), nullable=True),
    sa.Column('status', sa.Enum('NEW', 'CONTACTED', 'QUALIFIED', 'QUOTATION', 'NEGOTIATION', 'LOST', 'WON', 'DISCONTINUED', name='leadstatus'), nullable=False),
    sa.Column('source', sa.Enum('WEBSITE', 'SOCIAL_MEDIA', 'EMAIL_CAMPAIGN', 'REFERRAL', 'OTHER', name='leadsource'), nullable=False),
    sa.Column('score', be_kit.databases.NominalField(precision=30, scale=15), nullable=True),
    sa.Column('expected_revenue', be_kit.databases.NominalField(precision=30, scale=15), nullable=True),
    sa.Column('customer_id', sa.BigInteger(), nullable=False),
    sa.Column('sales_team_id', sa.BigInteger(), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('organization_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('last_modified_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('created_by_id', sa.BigInteger(), nullable=True),
    sa.Column('last_modified_by_id', sa.BigInteger(), nullable=True),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['created_by_id'], ['uam_user.pk'], name=op.f('fk_crm_lead_created_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['customer_id'], ['crm_customer.pk'], name=op.f('fk_crm_lead_customer_id_crm_customer'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['last_modified_by_id'], ['uam_user.pk'], name=op.f('fk_crm_lead_last_modified_by_id_uam_user'), ondelete='SET NULL'),
    sa.ForeignKeyConstraint(['organization_id'], ['uam_organization.pk'], name=op.f('fk_crm_lead_organization_id_uam_organization'), ondelete='RESTRICT'),
    sa.ForeignKeyConstraint(['sales_team_id'], ['crm_sales_team.pk'], name=op.f('fk_crm_lead_sales_team_id_crm_sales_team'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_crm_lead')),
    sa.UniqueConstraint('organization_id', 'name', name=op.f('uq_crm_lead_organization_id'))
    )
    op.create_index(op.f('ix_crm_lead_identifier'), 'crm_lead', ['identifier'], unique=True)
    op.create_index(op.f('ix_crm_lead_source'), 'crm_lead', ['source'], unique=False)
    op.create_index(op.f('ix_crm_lead_status'), 'crm_lead', ['status'], unique=False)
    op.create_table('crm_lead_tag',
    sa.Column('lead_id', sa.BigInteger(), nullable=False),
    sa.Column('tag_id', sa.BigInteger(), nullable=False),
    sa.Column('pk', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['lead_id'], ['crm_lead.pk'], name=op.f('fk_crm_lead_tag_lead_id_crm_lead'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['tag_id'], ['core_services_tag.pk'], name=op.f('fk_crm_lead_tag_tag_id_core_services_tag'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('pk', name=op.f('pk_crm_lead_tag')),
    sa.UniqueConstraint('lead_id', 'tag_id', name=op.f('uq_crm_lead_tag_lead_id'))
    )
    op.create_index(op.f('ix_crm_lead_tag_lead_id'), 'crm_lead_tag', ['lead_id'], unique=False)
    op.create_index(op.f('ix_crm_lead_tag_tag_id'), 'crm_lead_tag', ['tag_id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_crm_lead_tag_tag_id'), table_name='crm_lead_tag')
    op.drop_index(op.f('ix_crm_lead_tag_lead_id'), table_name='crm_lead_tag')
    op.drop_table('crm_lead_tag')
    op.drop_index(op.f('ix_crm_lead_status'), table_name='crm_lead')
    op.drop_index(op.f('ix_crm_lead_source'), table_name='crm_lead')
    op.drop_index(op.f('ix_crm_lead_identifier'), table_name='crm_lead')
    op.drop_table('crm_lead')
    op.drop_index(op.f('ix_crm_customer_tag_tag_id'), table_name='crm_customer_tag')
    op.drop_index(op.f('ix_crm_customer_tag_customer_id'), table_name='crm_customer_tag')
    op.drop_table('crm_customer_tag')
    op.drop_index(op.f('ix_crm_sales_team_tag_tag_id'), table_name='crm_sales_team_tag')
    op.drop_index(op.f('ix_crm_sales_team_tag_sales_team_id'), table_name='crm_sales_team_tag')
    op.drop_table('crm_sales_team_tag')
    op.drop_table('crm_sales_team_member')
    op.drop_table('crm_customer')
    op.drop_table('crm_sales_team')
    op.drop_index(op.f('ix_crm_lead_counter_counter_date'), table_name='crm_lead_counter')
    op.drop_table('crm_lead_counter')
    # ### end Alembic commands ###
