from datetime import date
from sqlalchemy import Select, select

from be_kit.repositories import BaseRepository
from be_core_services.tag.repositories import TagRepositoryMixin
from . import models


class LeadRepository(TagRepositoryMixin, BaseRepository):
    model = models.Lead
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query

    async def acreate(self, _commit: bool = True, **kwargs):
        today = date.today()
        counter = await self.aget_counter(today, kwargs["organization_id"])
        kwargs["identifier"] = self.get_lead_id(today, counter)
        return await super().acreate(_commit, **kwargs)

    async def aget_counter(self, dt: date, organization_id: int):
        query = select(models.Counter).filter_by(
            organization_id=organization_id, counter_date=dt
        )
        obj = await self.session.execute(query)
        obj = obj.scalar()
        if obj is None:
            obj = models.Counter(
                organization_id=organization_id, counter_date=dt, counter=0
            )
            self.session.add(obj)
        else:
            obj.counter += 1
            self.session.add(obj)
        await self.session.flush()
        return obj.counter

    def get_lead_id(self, dt: date, counter: int):
        return f"L{dt.strftime('%y%m%d')}{counter:03d}"
