from enum import Enum, StrEnum

from be_kit.enums import StrEnumWithMixins
from be_uam.kit.enums import MetadataOrderingMixin


class LeadSource(Enum):
    WEBSITE = "Website"
    SOCIAL_MEDIA = "Social Media"
    EMAIL_CAMPAIGN = "Email Campaign"
    REFERRAL = "Referral"
    OTHER = "Other"


class LeadStatus(StrEnum):
    NEW = "New"
    CONTACTED = "Contacted"
    QUALIFIED = "Qualified"
    QUOTATION = "Quotation"
    NEGOTIATION = "Negotiation"
    LOST = "Lost"
    WON = "Won"
    DISCONTINUED = "Discontinued"


class LeadOrdering(MetadataOrderingMixin, StrEnumWithMixins):
    IDENTIFIER = "identifier"
    IDENTIFIER_DESC = "-identifier"
    NAME = "name"
    NAME_DESC = "-name"
    DESCRIPTION = "description"
    DESCRIPTION_DESC = "-description"
    STATUS = "status"
    STATUS_DESC = "-status"
    SOURCE = "source"
    SOURCE_DESC = "-source"
    SCORE = "score"
    SCORE_DESC = "-score"
    EXPECTED_REVENUE = "expected_revenue"
    EXPECTED_REVENUE_DESC = "-expected_revenue"
