from typing_extensions import Annotated

from fastapi import File, UploadFile
from pydantic import EmailStr, PositiveInt, StringConstraints
from pydantic_extra_types.phone_numbers import PhoneNumber

from be_kit.paginations import BasePaginatedResponse
from be_kit.schemas import BaseSchema, BaseORMSchema
from be_uam.kit.schemas import MetadataMixin
from be_uam.user.schemas import UserMin
from be_core_services.contact.enums import ContactIndustryType, ContactLegalType
from be_core_services.contact.schemas import ContactMin
from be_core_services.tag.schemas import TagListMixin, TagListWriteMixin
from . import enums


# Customer


class CustomerCreate(TagListWriteMixin, BaseSchema):
    contact_id: PositiveInt


class Customer(TagListMixin, MetadataMixin, BaseORMSchema):
    contact: ContactMin


class PaginatedCustomer(BasePaginatedResponse):
    items: list[Customer]


class CustomerFilter(BaseSchema):
    contact_id: PositiveInt | None = None
    contact___name: str | None = None
    contact___name__icontains: str | None = None
    contact___legal_type: ContactLegalType | None = None


class CustomerMin(BaseORMSchema):
    contact: ContactMin
    pass


class CustomerOpt(CustomerMin):
    pass


class PaginatedCustomerOpt(BasePaginatedResponse):
    items: list[CustomerOpt]


class CustomerUpload(BaseSchema):
    file: Annotated[UploadFile, File()]


class CustomerValidator(BaseSchema):
    name: Annotated[str, StringConstraints(min_length=1, max_length=20)]
    tax_id: Annotated[str, StringConstraints(min_length=1, max_length=20)]
    legal_type: ContactLegalType
    industry_type: ContactIndustryType
    address: Annotated[str, StringConstraints(min_length=1, max_length=20)]
    contact_name: Annotated[str, StringConstraints(min_length=1, max_length=50)]
    phone_number: Annotated[str, StringConstraints(min_length=1, max_length=15)]
    contact_email: Annotated[str, StringConstraints(min_length=1, max_length=50)]



UserMin.model_rebuild()
