from sqlalchemy import Select

from be_kit.repositories import BaseRepository
from be_core_services.tag.repositories import TagRepositoryMixin
from . import models


class CustomerRepository(TagRepositoryMixin, BaseRepository):
    model = models.Customer
    filter_by_organization = True

    def add_organization_filter(self, query: Select):
        query = query.filter_by(organization_id=self.organization_id)
        return query
