from sqlalchemy import (
    BigInteger,
    Enum,
    ForeignKey,
    String,
    UniqueConstraint,
)
from sqlalchemy.orm import Mapped, declared_attr, mapped_column, relationship

from be_kit.databases import BaseModel, SoftDeleteMixin
from be_uam.kit.models import MetadataMixin, OrganizationMixin
from be_uam.user.models import User
from be_core_services.contact.models import Contact
from be_core_services.tag.models import Tag
from . import enums


class Customer(SoftDeleteMixin, OrganizationMixin, MetadataMixin, BaseModel):
    __tablename__ = "crm_customer"
    __table_args__ = (UniqueConstraint("organization_id", "contact_id"),)

    contact_id: Mapped[int] = mapped_column(
        BigInteger,
        ForeignKey(f"{Contact.__tablename__}.pk", ondelete="CASCADE"),
    )
    contact: Mapped[Contact] = relationship(
        Contact, passive_deletes=True, lazy="selectin"
    )
    tags: Mapped[list[Tag]] = relationship(
        secondary="crm_customer_tag", lazy="selectin"
    )


class CustomerTag(BaseModel):
    __tablename__ = "crm_customer_tag"
    __table_args__ = (UniqueConstraint("customer_id", "tag_id"),)

    customer_id: Mapped[int] = mapped_column(
        BigInteger,
        ForeignKey("crm_customer.pk", ondelete="CASCADE"),
        index=True,
    )
    tag_id: Mapped[int] = mapped_column(
        BigInteger,
        ForeignKey(f"{Tag.__tablename__}.pk", ondelete="CASCADE"),
        index=True,
    )
