from typing_extensions import Annotated
from pydantic import PositiveInt, StringConstraints

from be_kit.paginations import BasePaginatedResponse
from be_kit.schemas import BaseSchema, BaseORMSchema, NominalType
from be_core_services.country.schemas import CurrencyMin
from be_uam.kit.schemas import MetadataMixin
from be_uam.user.schemas import UserMin
from . import enums


# Warehouse


class BaseWarehouse:
    name: str
    description: str | None
    removal_strategy: enums.WarehouseRemovalStrategy


class WarehouseCreate(BaseWarehouse, BaseSchema):
    pass


class WarehouseUpdate(BaseWarehouse, BaseSchema):
    pass


class Warehouse(MetadataMixin, BaseWarehouse, BaseORMSchema):
    identifier: Annotated[
        str,
        StringConstraints(min_length=1, max_length=10),
    ]


class PaginatedWarehouse(BasePaginatedResponse):
    items: list[Warehouse]


class WarehouseFilter(BaseSchema):
    name: str | None = None
    description: str | None = None
    identifier: str | None = None


class WarehouseMin(BaseWarehouse, BaseORMSchema):
    identifier: Annotated[
        str,
        StringConstraints(min_length=1, max_length=10),
    ]
    pass


class WarehouseOpt(WarehouseMin):
    pass


class PaginatedWarehouseOpt(BasePaginatedResponse):
    items: list[WarehouseOpt]


UserMin.model_rebuild()
