from datetime import date
from decimal import Decimal

from sqlalchemy import (
    BigInteger,
    Enum,
    ForeignKey,
    String,
    UniqueConstraint,
    Date,
)
from sqlalchemy.orm import Mapped, mapped_column, relationship

from be_kit.databases import BaseModel, SoftDeleteMixin, NominalField
from be_uam.kit.models import MetadataMixin, OrganizationMixin
from be_core_services.country.models import Currency
from . import enums


class Warehouse(SoftDeleteMixin, OrganizationMixin, MetadataMixin, BaseModel):
    __tablename__ = "inventory_warehouse"
    __table_args__ = (UniqueConstraint("organization_id", "name"),)

    name: Mapped[str] = mapped_column(String(100), index=True)
    description: Mapped[str | None] = mapped_column(String(500), nullable=True)
    identifier: Mapped[str] = mapped_column(String(10), unique=True, index=True)
    removal_strategy: Mapped[enums.WarehouseRemovalStrategy] = mapped_column(
        Enum(enums.WarehouseRemovalStrategy),
        nullable=False,
    )


class WarehouseCounter(OrganizationMixin, BaseModel):
    __tablename__ = "inventory_warehouse_counter"
    __table_args__ = (UniqueConstraint("organization_id", "counter_date"),)

    counter_date: Mapped[date] = mapped_column(Date, index=True)
    counter: Mapped[int] = mapped_column(BigInteger, default=0)
